/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class BlobAccessor
extends Accessor {
    static final int maxLength = 4000;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    BlobAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 113, 113, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BlobAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 113, 113, s2, false);
        this.initForDescribe(113, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 4000;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    Object getObject(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getBLOB(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    BLOB getBLOB(int n2) throws SQLException {
        BLOB bLOB = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            bLOB = new BLOB(this.statement.connection, byArray);
            if (this.lobPrefetchSizeForThisColumn != -1 && this.prefetchedLobSize != null) {
                bLOB.setActivePrefetch(true);
                bLOB.setLength(this.prefetchedLobSize[n2]);
                bLOB.setChunkSize(this.prefetchedLobChunkSize[n2]);
                if (this.prefetchedLobDataL != null && this.prefetchedLobDataL[n2] > 0) {
                    this.initializeBlobForPrefetch(n2, bLOB);
                } else {
                    bLOB.setPrefetchedData(null);
                }
            }
        }
        return bLOB;
    }

    void initializeBlobForPrefetch(int n2, BLOB bLOB) throws SQLException {
        int n3 = this.prefetchedLobDataL[n2];
        byte[] byArray = this.prefetchedLobData[n2];
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        bLOB.setPrefetchedData(byArray2);
    }

    InputStream getAsciiStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        return bLOB.asciiStreamValue();
    }

    Reader getCharacterStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        return bLOB.characterStreamValue();
    }

    InputStream getBinaryStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        return bLOB.getBinaryStream();
    }

    byte[] privateGetBytes(int n2) throws SQLException {
        return super.getBytes(n2);
    }

    byte[] getBytes(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        InputStream inputStream = bLOB.getBinaryStream();
        int n3 = bLOB.getBufferSize();
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        byte[] byArray = new byte[n3];
        try {
            while ((n4 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return byteArrayOutputStream.toByteArray();
    }

    String getString(int n2) throws SQLException {
        this.unimpl("getString");
        return null;
    }

    String getNString(int n2) throws SQLException {
        this.unimpl("getNString");
        return null;
    }
}

