/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.NCLOB;
import oracle.sql.SQLName;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final long JDBC_OCI_LIBRARY_VERSION = Long.parseLong("11.2.0.2.0".replaceAll("\\.", ""));
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private String password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    static final String defaultDriverNameAttribute = "jdbcoci";
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final int EOJ_GET_STORAGE_ERROR = -4;
    private static final int EOJ_ORA3113_SERVER_NORMAL = -6;
    private static final String OCILIBRARY = "ocijdbc11";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_SYSASM = 32768;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    static final int T2C_CONNECTION_FLAG_DEFAULT_LOB_PREFETCH = 0;
    static final int T2C_CONNECTION_FLAG_PRELIM_AUTH = 1;
    private static boolean isLibraryLoaded;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    ByteBuffer nioBufferForLob;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    protected T2CConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
        this.initialize();
    }

    final void initializePassword(String string) throws SQLException {
        this.password = string;
    }

    protected void initialize() {
        this.allocQueryMetaDataBuffers();
    }

    private void allocQueryMetaDataBuffers() {
        this.queryMetaData1Offset = 0;
        this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
        this.queryMetaData2Offset = 0;
        this.queryMetaData2 = new byte[this.queryMetaData2Size];
        this.namedTypeAccessorByteLen = 0;
        this.refTypeAccessorByteLen = 0;
    }

    void reallocateQueryMetaData(int n2, int n3) {
        this.queryMetaData1 = null;
        this.queryMetaData2 = null;
        this.queryMetaData1Size = Math.max(n2, this.queryMetaData1Size);
        this.queryMetaData2Size = Math.max(n3, this.queryMetaData2Size);
        this.allocQueryMetaDataBuffers();
    }

    protected void logon() throws SQLException {
        if (this.database == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 64);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(this.ocidll);
        }
        if (this.ociConnectionPoolIsPooling) {
            this.processOCIConnectionPooling();
        } else {
            byte[] byArray;
            long l2 = this.ociSvcCtxHandle;
            long l3 = this.ociEnvHandle;
            long l4 = this.ociErrHandle;
            if (l2 != 0L && l3 != 0L) {
                if (this.ociDriverCharset == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.m_clientCharacterSet = new Integer(this.ociDriverCharset).shortValue();
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                short[] sArray = new short[5];
                long[] lArray = new long[]{this.defaultLobPrefetchSize};
                this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, l3, l2, l4, sArray, lArray), this.sqlWarning);
                this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
                this.byteAlign = (byte)(sArray[2] & 0xFF);
                this.timeZoneVersionNumber = (sArray[3] << 16) + (sArray[4] & 0xFFFF);
                return;
            }
            if (this.internalLogon == null) {
                this.logon_mode = 0;
            } else if (this.internalLogon.equalsIgnoreCase("SYSDBA")) {
                this.logon_mode = 2;
            } else if (this.internalLogon.equalsIgnoreCase("SYSOPER")) {
                this.logon_mode = 4;
            } else if (this.internalLogon.equalsIgnoreCase("SYSASM")) {
                this.logon_mode = 32768;
            }
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            String string = this.setNewPassword;
            byte[] byArray5 = new byte[]{};
            byte[] byArray6 = new byte[]{};
            byte[] byArray7 = new byte[]{};
            this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.ocidll) : T2CConnection.getClientCharSetId();
            if (string != null) {
                byArray5 = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
            }
            if (this.editionName != null) {
                byArray6 = DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
            }
            byArray7 = this.driverNameAttribute == null ? DBConversion.stringToDriverCharBytes(defaultDriverNameAttribute, this.m_clientCharacterSet) : DBConversion.stringToDriverCharBytes(this.driverNameAttribute, this.m_clientCharacterSet);
            byArray2 = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            byArray3 = this.proxyClientName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.proxyClientName, this.m_clientCharacterSet);
            byArray4 = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
            byte[] byArray8 = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
            short[] sArray = new short[5];
            String string2 = null;
            string2 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault());
            byte[] byArray9 = string2 != null ? string2.getBytes() : null;
            string2 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault());
            byte[] byArray10 = byArray = string2 != null ? string2.getBytes() : null;
            if (byArray9 == null || byArray == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            TimeZone timeZone = TimeZone.getDefault();
            String string3 = timeZone.getID();
            if (!ZONEIDMAP.isValidRegion(string3) || !this.timezoneAsRegion) {
                int n2 = timeZone.getOffset(System.currentTimeMillis());
                int n3 = n2 / 3600000;
                int n4 = n2 / 60000 % 60;
                string3 = (n3 < 0 ? "" + n3 : "+" + n3) + (n4 < 10 ? ":0" + n4 : ":" + n4);
            }
            T2CConnection.doSetSessionTimeZone(string3);
            this.sessionTimeZone = string3;
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            long[] lArray = new long[]{this.defaultLobPrefetchSize, this.prelimAuth ? 1 : 0};
            this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray6, byArray6.length, byArray7, byArray7.length, byArray8, byArray8.length, this.m_clientCharacterSet, this.logon_mode, sArray, byArray9, byArray, lArray), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray6, byArray6.length, byArray7, byArray7.length, byArray8, byArray8.length, this.logon_mode, sArray, byArray9, byArray, lArray), this.sqlWarning);
            this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
            this.byteAlign = (byte)(sArray[2] & 0xFF);
            this.timeZoneVersionNumber = (sArray[3] << 16) + (sArray[4] & 0xFFFF);
        }
    }

    protected void logoff() throws SQLException {
        try {
            if (this.lifecycle == 2) {
                this.checkError(this.t2cLogoff(this.m_nativeState));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.m_nativeState = 0L;
    }

    public void open(OracleStatement oracleStatement) throws SQLException {
        byte[] byArray = oracleStatement.sqlObject.getSql(oracleStatement.processEscapes, oracleStatement.convertNcharLiterals).getBytes();
        this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, byArray, byArray.length, oracleStatement, false, oracleStatement.rowPrefetch));
    }

    void cancelOperationOnServer() throws SQLException {
        this.checkError(this.t2cCancel(this.m_nativeState));
    }

    native int t2cAbort(long var1);

    void doAbort() throws SQLException {
        this.checkError(this.t2cAbort(this.m_nativeState));
    }

    protected void doSetAutoCommit(boolean bl) throws SQLException {
        this.checkError(this.t2cSetAutoCommit(this.m_nativeState, bl));
    }

    protected void doCommit(int n2) throws SQLException {
        this.checkError(this.t2cCommit(this.m_nativeState, n2));
    }

    protected void doRollback() throws SQLException {
        this.checkError(this.t2cRollback(this.m_nativeState));
    }

    synchronized int doPingDatabase() throws SQLException {
        if (this.t2cPingDatabase(this.m_nativeState) == 0) {
            return 0;
        }
        return -1;
    }

    protected String doGetDatabaseProductVersion() throws SQLException {
        byte[] byArray = this.t2cGetProductionVersion(this.m_nativeState);
        return this.conversion.CharBytesToString(byArray, byArray.length);
    }

    protected short doGetVersionNumber() throws SQLException {
        short s2 = 0;
        try {
            String string = this.doGetDatabaseProductVersion();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
            String string2 = null;
            int n2 = 0;
            short s3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                try {
                    s3 = Integer.decode(string2).shortValue();
                    s2 = (short)(s2 * 10 + s3);
                    if (++n2 != 4) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (s2 == -1) {
            s2 = 0;
        }
        return s2;
    }

    public ClobDBAccess createClobDBAccess() {
        return this;
    }

    public BlobDBAccess createBlobDBAccess() {
        return this;
    }

    public BfileDBAccess createBfileDBAccess() {
        return this;
    }

    protected SQLWarning checkError(int n2) throws SQLException {
        return this.checkError(n2, null);
    }

    protected SQLWarning checkError(int n2, SQLWarning sQLWarning) throws SQLException {
        switch (n2) {
            case 0: {
                break;
            }
            case -1: 
            case 1: {
                T2CError t2CError = new T2CError();
                int n3 = -1;
                if (this.lifecycle != 1 && this.lifecycle != 16) {
                    if (this.fatalErrorNumber != 0) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 269);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                n3 = this.t2cDescribeError(this.m_nativeState, t2CError, t2CError.m_errorMessage);
                String string = null;
                if (n3 != -1) {
                    int n4;
                    for (n4 = 0; n4 < t2CError.m_errorMessage.length && t2CError.m_errorMessage[n4] != 0; ++n4) {
                    }
                    if (this.conversion == null) {
                        throw new Error("conversion == null");
                    }
                    if (t2CError == null) {
                        throw new Error("l_error == null");
                    }
                    string = this.conversion.CharBytesToString(t2CError.m_errorMessage, n4, true);
                }
                switch (t2CError.m_errorNumber) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: {
                        this.internalClose();
                        break;
                    }
                    case 3113: 
                    case 3114: {
                        this.close();
                        break;
                    }
                    case -6: {
                        t2CError.m_errorNumber = 3113;
                    }
                }
                if (n3 == -1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fetch error message failed!");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 == -1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), string, t2CError.m_errorNumber);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sQLWarning = DatabaseError.addSqlWarning(sQLWarning, string, t2CError.m_errorNumber);
                break;
            }
            case -4: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return sQLWarning;
    }

    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T2CStatement t2CStatement = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
        t2CStatement.needToParse = false;
        t2CStatement.serverCursor = true;
        t2CStatement.isOpen = true;
        t2CStatement.processEscapes = false;
        t2CStatement.prepareForNewResults(true, false);
        t2CStatement.sqlObject.initialize("select unknown as ref cursor from whatever");
        t2CStatement.sqlKind = 1;
        this.checkError(this.t2cCreateStatement(this.m_nativeState, oracleStatement.c_state, byArray, byArray.length, t2CStatement, true, this.defaultRowPrefetch));
        oracleStatement.addChild(t2CStatement);
        return t2CStatement;
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n2) throws SQLException {
        boolean bl = false;
        if (oracleTypeCLOB != null) {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            SQLName.parse(oracleTypeADT.getFullName(), stringArray, stringArray2, true);
            String string = "\"" + stringArray[0] + "\".\"" + stringArray2[0] + "\"";
            byte[] byArray = this.conversion.StringToCharBytes(string);
            int n3 = this.t2cGetFormOfUse(this.m_nativeState, oracleTypeCLOB, byArray, byArray.length, n2);
            if (n3 < 0) {
                this.checkError(n3);
            }
            oracleTypeCLOB.setForm(n3);
        }
    }

    public long getTdoCState(String string, String string2) throws SQLException {
        int[] nArray;
        String string3 = "\"" + string + "\".\"" + string2 + "\"";
        byte[] byArray = this.conversion.StringToCharBytes(string3);
        long l2 = this.t2cGetTDO(this.m_nativeState, byArray, byArray.length, nArray = new int[1]);
        if (l2 == 0L) {
            this.checkError(nArray[0]);
        }
        return l2;
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.getOCIHandles();
    }

    public synchronized Properties getOCIHandles() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.nativeInfo == null) {
            long[] lArray = new long[3];
            this.checkError(this.t2cGetHandles(this.m_nativeState, lArray));
            this.nativeInfo = new Properties();
            this.nativeInfo.put("OCIEnvHandle", String.valueOf(lArray[0]));
            this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(lArray[1]));
            this.nativeInfo.put("OCIErrHandle", String.valueOf(lArray[2]));
            this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
        }
        return this.nativeInfo;
    }

    public Properties getServerSessionInfo() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.sessionProperties == null) {
            this.sessionProperties = new Properties();
        }
        if (this.getVersionNumber() < 10200) {
            this.queryFCFProperties(this.sessionProperties);
        } else {
            this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, this.sessionProperties));
        }
        return this.sessionProperties;
    }

    public byte getInstanceProperty(OracleConnection.InstanceProperty instanceProperty) throws SQLException {
        byte by = 0;
        if (instanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
            by = this.t2cGetAsmVolProperty(this.m_nativeState);
        } else if (instanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
            by = this.t2cGetInstanceType(this.m_nativeState);
        }
        return by;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Properties properties = new Properties();
        this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, properties));
        return properties;
    }

    public void setConnectionPoolInfo(int n2, int n3, int n4, int n5, int n6, int n7) throws SQLException {
        this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, n2, n3, n4, n5, n6, n7));
    }

    public void ociPasswordChange(String string, String string2, String string3) throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = string == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
        byte[] byArray2 = string2 == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(string2, this.m_clientCharacterSet);
        byte[] byArray3 = string3 == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(string3, this.m_clientCharacterSet);
        this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length), this.sqlWarning);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processOCIConnectionPooling() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        T2CConnection t2CConnection = null;
        if (this.ociConnectionPoolLogonMode == "connection_pool") {
            this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.ocidll) : T2CConnection.getClientCharSetId();
        } else {
            t2CConnection = (T2CConnection)this.ociConnectionPoolObject;
            this.m_clientCharacterSet = t2CConnection.m_clientCharacterSet;
        }
        byte[] byArray = null;
        byte[] byArray2 = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
        byte[] byArray3 = this.editionName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
        byte[] byArray4 = DBConversion.stringToDriverCharBytes(this.driverNameAttribute == null ? defaultDriverNameAttribute : this.driverNameAttribute, this.m_clientCharacterSet);
        byte[] byArray5 = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
        byte[] byArray6 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
        byte[] byArray7 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
        if (byArray6 == null || byArray7 == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        short[] sArray = new short[5];
        long[] lArray = new long[]{this.defaultLobPrefetchSize};
        if (this.ociConnectionPoolLogonMode == "connection_pool") {
            byArray = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.logon_mode = 5;
            if (this.lifecycle != 1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 0, "Internal Error: ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int[] nArray = new int[6];
            OracleOCIConnectionPool.readPoolConfig(this.ociConnectionPoolMinLimit, this.ociConnectionPoolMaxLimit, this.ociConnectionPoolIncrement, this.ociConnectionPoolTimeout, this.ociConnectionPoolNoWait, this.ociConnectionPoolTransactionDistributed, nArray);
            this.sqlWarning = this.checkError(this.t2cCreateConnPool(byArray, byArray.length, byArray2, byArray2.length, byArray5, byArray5.length, this.m_clientCharacterSet, this.logon_mode, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]), this.sqlWarning);
            this.versionNumber = (short)10000;
        } else if (this.ociConnectionPoolLogonMode == "connpool_connection") {
            this.logon_mode = 6;
            byArray = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, sArray, byArray6, byArray7, lArray), this.sqlWarning);
        } else if (this.ociConnectionPoolLogonMode == "connpool_alias_connection") {
            this.logon_mode = 8;
            byte[] byArray8 = null;
            byArray8 = (byte[])this.ociConnectionPoolConnID;
            byArray = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, byArray8, byArray8 == null ? 0 : byArray8.length, sArray, byArray6, byArray7, lArray), this.sqlWarning);
        } else {
            if (this.ociConnectionPoolLogonMode != "connpool_proxy_connection") {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "connection-pool-logon");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.logon_mode = 7;
            String string = this.ociConnectionPoolProxyType;
            int n2 = this.ociConnectionPoolProxyNumRoles;
            String[] stringArray = null;
            if (n2 > 0) {
                stringArray = (String[])this.ociConnectionPoolProxyRoles;
            }
            byte[] byArray9 = null;
            byte[] byArray10 = null;
            byte[] byArray11 = null;
            byte[] byArray12 = null;
            int n3 = 0;
            if (string == "proxytype_user_name") {
                n3 = 1;
                String string2 = this.ociConnectionPoolProxyUserName;
                if (string2 != null) {
                    byArray9 = string2.getBytes();
                }
                if ((string2 = this.ociConnectionPoolProxyPassword) != null) {
                    byArray10 = string2.getBytes();
                }
            } else if (string == "proxytype_distinguished_name") {
                n3 = 2;
                String string3 = this.ociConnectionPoolProxyDistinguishedName;
                if (string3 != null) {
                    byArray11 = string3.getBytes();
                }
            } else {
                if (string != "proxytype_certificate") {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 107);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                n3 = 3;
                byArray12 = (byte[])this.ociConnectionPoolProxyCertificate;
            }
            byArray = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(t2CConnection.m_nativeState, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, this.logon_mode, n3, n2, stringArray, byArray9, byArray9 == null ? 0 : byArray9.length, byArray10, byArray10 == null ? 0 : byArray10.length, byArray11, byArray11 == null ? 0 : byArray11.length, byArray12, byArray12 == null ? 0 : byArray12.length, null, 0, sArray, byArray6, byArray7, lArray), this.sqlWarning);
        }
        this.conversion = new DBConversion(sArray[0], this.m_clientCharacterSet, sArray[1]);
        this.byteAlign = (byte)(sArray[2] & 0xFF);
        this.timeZoneVersionNumber = (sArray[3] << 16) + (sArray[4] & 0xFFFF);
    }

    public boolean isDescriptorSharable(OracleConnection oracleConnection) throws SQLException {
        T2CConnection t2CConnection = this;
        PhysicalConnection physicalConnection = (PhysicalConnection)oracleConnection.getPhysicalConnection();
        return t2CConnection == physicalConnection;
    }

    native int t2cBlobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, boolean var10, ByteBuffer var11);

    native int t2cClobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10, boolean var11, ByteBuffer var12);

    native int t2cBlobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int t2cClobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long t2cLobGetLength(long var1, byte[] var3, int var4);

    native int t2cBfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cBfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int t2cBfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String t2cBfileGetName(long var1, byte[] var3, int var4);

    native String t2cBfileGetDirAlias(long var1, byte[] var3, int var4);

    native int t2cBfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cLobGetChunkSize(long var1, byte[] var3, int var4);

    native int t2cLobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int t2cLobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int t2cLobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int t2cLobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int t2cLobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    private long lobLength(byte[] byArray) throws SQLException {
        long l2 = 0L;
        l2 = this.t2cLobGetLength(this.m_nativeState, byArray, byArray.length);
        this.checkError((int)l2);
        return l2;
    }

    private int blobRead(byte[] byArray, long l2, int n2, byte[] byArray2, boolean bl, ByteBuffer byteBuffer) throws SQLException {
        int n3 = 0;
        n3 = this.t2cBlobRead(this.m_nativeState, byArray, byArray.length, l2, n2, byArray2, byArray2.length, bl, byteBuffer);
        this.checkError(n3);
        return n3;
    }

    private int blobWrite(byte[] byArray, long l2, byte[] byArray2, byte[][] byArray3, int n2, int n3) throws SQLException {
        int n4 = 0;
        n4 = this.t2cBlobWrite(this.m_nativeState, byArray, byArray.length, l2, n3, byArray2, n2, byArray3);
        this.checkError(n4);
        return n4;
    }

    private int clobWrite(byte[] byArray, long l2, char[] cArray, byte[][] byArray2, boolean bl, int n2, int n3) throws SQLException {
        int n4 = 0;
        n4 = this.t2cClobWrite(this.m_nativeState, byArray, byArray.length, l2, n3, cArray, n2, byArray2, bl);
        this.checkError(n4);
        return n4;
    }

    private int lobGetChunkSize(byte[] byArray) throws SQLException {
        int n2 = 0;
        n2 = this.t2cLobGetChunkSize(this.m_nativeState, byArray, byArray.length);
        this.checkError(n2);
        return n2;
    }

    public synchronized long length(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public synchronized long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.hasPattern(bFILE, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(bFILE, bFILE2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        int n3;
        byte[] byArray2 = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray2 = bFILE.getLocator()) != null, 54);
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        if (this.useNio) {
            n3 = byArray.length;
            if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < n3) {
                this.nioBufferForLob = ByteBuffer.allocateDirect(n3);
            } else {
                this.nioBufferForLob.rewind();
            }
        }
        n3 = this.blobRead(byArray2, l2, n2, byArray, this.useNio, this.nioBufferForLob);
        if (this.useNio) {
            this.nioBufferForLob.get(byArray);
        }
        return n3;
    }

    public synchronized String getName(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        string = this.t2cBfileGetName(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public synchronized String getDirAlias(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        String string = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        string = this.t2cBfileGetDirAlias(this.m_nativeState, byArray, byArray.length);
        this.checkError(string.length());
        return string;
    }

    public synchronized void openFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cBfileOpen(this.m_nativeState, byArray, byArray.length, byArrayArray));
        bFILE.setLocator(byArrayArray[0]);
    }

    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cBfileIsOpen(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cBfileExists(this.m_nativeState, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.getLocator()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cBfileClose(this.m_nativeState, byArray, byArray.length, byArrayArray));
        bFILE.setLocator(byArrayArray[0]);
    }

    public synchronized void open(BFILE bFILE, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobOpen(this.m_nativeState, 114, byArray, byArray.length, n2, byArrayArray));
        bFILE.setShareBytes(byArrayArray[0]);
    }

    public synchronized void close(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobClose(this.m_nativeState, 114, byArray, byArray.length, byArrayArray));
        bFILE.setShareBytes(byArrayArray[0]);
    }

    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bFILE != null && (byArray = bFILE.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cLobIsOpen(this.m_nativeState, 114, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        this.checkTrue(bFILE != null && bFILE.shareBytes() != null, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        this.checkTrue(bFILE != null && bFILE.shareBytes() != null, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public synchronized long length(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public synchronized long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.hasPattern(bLOB, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        this.checkTrue(bLOB2 != null && bLOB2.shareBytes() != null, 54);
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(bLOB, bLOB2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        int n3;
        byte[] byArray2;
        byte[] byArray3 = null;
        int n4 = 0;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray3 = bLOB.getLocator()) != null, 54);
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        long l3 = -1L;
        if (bLOB.isActivePrefetch()) {
            byArray2 = bLOB.getPrefetchedData();
            l3 = bLOB.length();
            if (byArray2 != null && byArray2 != null && l2 <= (long)byArray2.length) {
                n3 = Math.min(byArray2.length - (int)l2 + 1, n2);
                System.arraycopy(byArray2, (int)l2 - 1, byArray, 0, n3);
                n4 += n3;
            }
        }
        if (n4 < n2 && (l3 == -1L || l2 - 1L + (long)n4 < l3)) {
            byArray2 = byArray;
            n3 = n4;
            int n5 = (l3 > 0L && l3 < (long)n2 ? (int)l3 : n2) - n4;
            if (n4 > 0) {
                byArray2 = new byte[n5];
            }
            if (this.useNio) {
                int n6 = byArray.length;
                if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < n6) {
                    this.nioBufferForLob = ByteBuffer.allocateDirect(n6);
                } else {
                    this.nioBufferForLob.rewind();
                }
            }
            n4 += this.blobRead(byArray3, l2 + (long)n4, n5, byArray2, this.useNio, this.nioBufferForLob);
            if (this.useNio) {
                this.nioBufferForLob.get(byArray2);
            }
            if (n3 > 0) {
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            }
        }
        return n4;
    }

    public synchronized int putBytes(BLOB bLOB, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.checkTrue(l2 >= 0L, 68);
        int n4 = 0;
        if (byArray == null || byArray.length == 0 || n3 <= 0) {
            n4 = 0;
        } else {
            byte[] byArray2 = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bLOB != null && (byArray2 = bLOB.getLocator()) != null, 54);
            byte[][] byArrayArray = new byte[1][];
            bLOB.setActivePrefetch(false);
            bLOB.clearCachedData();
            n4 = this.blobWrite(byArray2, l2, byArray, byArrayArray, n2, n3);
            bLOB.setLocator(byArrayArray[0]);
        }
        return n4;
    }

    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.getLocator()) != null, 54);
        return this.lobGetChunkSize(byArray);
    }

    public synchronized void trim(BLOB bLOB, long l2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        bLOB.setActivePrefetch(false);
        bLOB.clearCachedData();
        this.checkError(this.t2cLobTrim(this.m_nativeState, 113, l2, byArray, byArray.length, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        BLOB bLOB = null;
        this.checkTrue(this.lifecycle == 1, 8);
        bLOB = new BLOB((PhysicalConnection)connection);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 113, bl, n2, (short)0, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
        return bLOB;
    }

    public synchronized void freeTemporary(BLOB bLOB, boolean bl) throws SQLException {
        try {
            byte[] byArray = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
            byte[][] byArrayArray = new byte[1][];
            this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 113, byArray, byArray.length, byArrayArray));
            bLOB.setShareBytes(byArrayArray[0]);
        }
        catch (SQLException sQLException) {
            if (bl & sQLException.getErrorCode() == 64201) {
                LobPlsqlUtil.freeTemporaryLob(this, bLOB, 2004);
            }
            throw sQLException;
        }
    }

    public synchronized boolean isTemporary(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public synchronized void open(BLOB bLOB, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobOpen(this.m_nativeState, 113, byArray, byArray.length, n2, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized void close(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobClose(this.m_nativeState, 113, byArray, byArray.length, byArrayArray));
        bLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(bLOB != null && (byArray = bLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cLobIsOpen(this.m_nativeState, 113, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        this.checkTrue(bLOB != null && bLOB.shareBytes() != null, 54);
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    public synchronized long length(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        return this.lobLength(byArray);
    }

    public synchronized long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(cLOB, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && cLOB.shareBytes() != null, 54);
        this.checkTrue(cLOB2 != null && cLOB2.shareBytes() != null, 54);
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(cLOB, cLOB2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    public synchronized int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        int n3;
        char[] cArray2;
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        if (n2 <= 0 || cArray == null) {
            return 0;
        }
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        int n4 = 0;
        long l3 = -1L;
        if (cLOB.isActivePrefetch()) {
            l3 = cLOB.length();
            cArray2 = cLOB.getPrefetchedData();
            if (cArray2 != null && l2 <= (long)cArray2.length) {
                n3 = Math.min(cArray2.length - (int)l2 + 1, n2);
                System.arraycopy(cArray2, (int)l2 - 1, cArray, 0, n3);
                n4 += n3;
            }
        }
        if (n4 < n2 && (l3 == -1L || l2 - 1L + (long)n4 < l3)) {
            cArray2 = cArray;
            n3 = n4;
            int n5 = (l3 > 0L && l3 < (long)n2 ? (int)l3 : n2) - n4;
            if (n4 > 0) {
                cArray2 = new char[n5];
            }
            if (this.useNio) {
                int n6 = cArray.length * 2;
                if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < n6) {
                    this.nioBufferForLob = ByteBuffer.allocateDirect(n6);
                } else {
                    this.nioBufferForLob.rewind();
                }
            }
            n4 += this.t2cClobRead(this.m_nativeState, byArray, byArray.length, l2 + (long)n4, n5, cArray2, cArray2.length, cLOB.isNCLOB(), this.useNio, this.nioBufferForLob);
            if (this.useNio) {
                ByteBuffer byteBuffer = this.nioBufferForLob.order(ByteOrder.LITTLE_ENDIAN);
                CharBuffer charBuffer = byteBuffer.asCharBuffer();
                charBuffer.get(cArray2);
            }
            if (n3 > 0) {
                System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
            }
            this.checkError(n4);
        }
        return n4;
    }

    public synchronized int putChars(CLOB cLOB, long l2, char[] cArray, int n2, int n3) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(l2 >= 0L, 68);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        if (cArray == null) {
            return 0;
        }
        byte[][] byArrayArray = new byte[1][];
        cLOB.setActivePrefetch(false);
        cLOB.clearCachedData();
        int n4 = this.clobWrite(byArray, l2, cArray, byArrayArray, cLOB.isNCLOB(), n2, n3);
        cLOB.setLocator(byArrayArray[0]);
        return n4;
    }

    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.getLocator()) != null, 54);
        return this.lobGetChunkSize(byArray);
    }

    public synchronized void trim(CLOB cLOB, long l2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        cLOB.setActivePrefetch(false);
        cLOB.clearCachedData();
        this.checkError(this.t2cLobTrim(this.m_nativeState, 112, l2, byArray, byArray.length, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        CLOB cLOB = null;
        this.checkTrue(this.lifecycle == 1, 8);
        cLOB = s2 == 1 ? new CLOB((PhysicalConnection)connection) : new NCLOB((PhysicalConnection)connection);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 112, bl, n2, s2, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
        return cLOB;
    }

    public synchronized void freeTemporary(CLOB cLOB, boolean bl) throws SQLException {
        try {
            byte[] byArray = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
            byte[][] byArrayArray = new byte[1][];
            this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 112, byArray, byArray.length, byArrayArray));
            cLOB.setShareBytes(byArrayArray[0]);
        }
        catch (SQLException sQLException) {
            if (bl & sQLException.getErrorCode() == 64201) {
                LobPlsqlUtil.freeTemporaryLob(this, cLOB, 2005);
            }
            throw sQLException;
        }
    }

    public synchronized boolean isTemporary(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public synchronized void open(CLOB cLOB, int n2) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobOpen(this.m_nativeState, 112, byArray, byArray.length, n2, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized void close(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        byte[][] byArrayArray = new byte[1][];
        this.checkError(this.t2cLobClose(this.m_nativeState, 112, byArray, byArray.length, byArrayArray));
        cLOB.setShareBytes(byArrayArray[0]);
    }

    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        byte[] byArray = null;
        this.checkTrue(this.lifecycle == 1, 8);
        this.checkTrue(cLOB != null && (byArray = cLOB.shareBytes()) != null, 54);
        boolean[] blArray = new boolean[1];
        this.checkError(this.t2cLobIsOpen(this.m_nativeState, 112, byArray, byArray.length, blArray));
        return blArray[0];
    }

    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    public Reader newReader(CLOB cLOB, int n2, long l2, long l3) throws SQLException {
        return new OracleClobReader(cLOB, n2, l2, l3);
    }

    public Writer newWriter(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        this.appCallback = oracleOCIFailover;
        this.appCallbackObject = object;
        this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
    }

    synchronized int callTAFCallbackMethod(int n2, int n3) {
        int n4 = 0;
        if (this.appCallback != null) {
            n4 = this.appCallback.callbackFn(this, this.appCallbackObject, n2, n3);
        }
        return n4;
    }

    public int getHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.t2cGetHeapAllocSize(this.m_nativeState);
        if (n2 < 0) {
            if (n2 == -999) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState);
        if (n2 < 0) {
            if (n2 == -999) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.checkError(n2);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2;
    }

    public static final short getClientCharSetId() {
        return 871;
    }

    public static short getDriverCharSetIdFromNLS_LANG(String string) throws SQLException {
        short s2;
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(string);
        }
        if ((s2 = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
            SQLException sQLException = DatabaseError.createSqlException(null, 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return s2;
    }

    void doProxySession(int n2, Properties properties) throws SQLException {
        byte[] byArray;
        Object object = null;
        int n3 = 0;
        this.savedUser = this.userName;
        this.userName = null;
        byte[] byArray2 = byArray = new byte[0];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        switch (n2) {
            case 1: {
                this.userName = properties.getProperty("PROXY_USER_NAME");
                String string = properties.getProperty("PROXY_USER_PASSWORD");
                if (this.userName != null) {
                    byArray4 = DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                }
                if (string == null) break;
                byArray3 = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
                break;
            }
            case 2: {
                String string = properties.getProperty("PROXY_DISTINGUISHED_NAME");
                if (string == null) break;
                byArray2 = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
                break;
            }
            case 3: {
                Object object2 = properties.get("PROXY_CERTIFICATE");
                byArray = (byte[])object2;
            }
        }
        String[] stringArray = (String[])properties.get("PROXY_ROLES");
        if (stringArray != null) {
            n3 = stringArray.length;
            object = new byte[n3][];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (stringArray[i2] == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object[i2] = DBConversion.stringToDriverCharBytes(stringArray[i2], this.m_clientCharacterSet);
            }
        }
        this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, n2, byArray4, byArray4.length, byArray3, byArray3.length, byArray2, byArray2.length, byArray, byArray.length, n3, (byte[][])object), this.sqlWarning);
        this.isProxy = true;
    }

    void closeProxySession() throws SQLException {
        this.checkError(this.t2cCloseProxySession(this.m_nativeState));
        this.userName = this.savedUser;
    }

    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        int n2;
        String string = autoKeyInfo.getTableName();
        byte[] byArray = DBConversion.stringToDriverCharBytes(string, this.m_clientCharacterSet);
        boolean bl = false;
        do {
            if ((n2 = T2CConnection.t2cDescribeTable(this.m_nativeState, byArray, byArray.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size)) == -1) {
                this.checkError(n2);
            }
            if (n2 != T2CStatement.T2C_EXTEND_BUFFER) continue;
            bl = true;
            this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
        } while (bl);
        this.processDescribeTableData(n2, autoKeyInfo);
    }

    private void processDescribeTableData(int n2, AutoKeyInfo autoKeyInfo) throws SQLException {
        short[] sArray = this.queryMetaData1;
        byte[] byArray = this.queryMetaData2;
        int n3 = this.queryMetaData1Offset;
        int n4 = this.queryMetaData2Offset;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            short s2 = sArray[n3 + 0];
            short s3 = sArray[n3 + 6];
            String string = T2CConnection.bytes2String(byArray, n4, s3, this.conversion);
            short s4 = sArray[n3 + 1];
            short s5 = sArray[n3 + 11];
            boolean bl = sArray[n3 + 2] != 0;
            short s6 = sArray[n3 + 5];
            short s7 = sArray[n3 + 3];
            short s8 = sArray[n3 + 4];
            short s9 = sArray[n3 + 12];
            n4 += s3;
            n3 += 13;
            String string2 = null;
            if (s9 > 0) {
                string2 = T2CConnection.bytes2String(byArray, n4, s9, this.conversion);
                n4 += s9;
            }
            autoKeyInfo.fillDescribedData(i2, string, s2, s5 > 0 ? s5 : s4, bl, s6, s7, s8, string2);
        }
    }

    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        this.checkError(this.t2cSetApplicationContext(this.m_nativeState, string, string2, string3));
    }

    void doClearAllApplicationContext(String string) throws SQLException {
        this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, string));
    }

    void doStartup(int n2) throws SQLException {
        this.checkError(this.t2cStartupDatabase(this.m_nativeState, n2));
    }

    void doShutdown(int n2) throws SQLException {
        this.checkError(this.t2cShutdownDatabase(this.m_nativeState, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadNativeLibrary(String string) throws SQLException {
        if (string == null || string.equals(OCILIBRARY)) {
            Class<T2CConnection> clazz = T2CConnection.class;
            synchronized (T2CConnection.class) {
                if (!isLibraryLoaded) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            int n2 = T2CConnection.getLibraryVersionNumber();
                            if ((long)n2 != JDBC_OCI_LIBRARY_VERSION) {
                                throw new Error("Incompatible version of libocijdbc[Jdbc:" + JDBC_OCI_LIBRARY_VERSION + ", Jdbc-OCI:" + n2);
                            }
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        Class<T2CConnection> clazz = T2CConnection.class;
        synchronized (T2CConnection.class) {
            block10: {
                try {
                    System.loadLibrary(string);
                    isLibraryLoaded = true;
                }
                catch (SecurityException securityException) {
                    if (isLibraryLoaded) break block10;
                    System.loadLibrary(string);
                    isLibraryLoaded = true;
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    private final void checkTrue(boolean bl, int n2) throws SQLException {
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return this.t2cPlatformIsLittleEndian(this.m_nativeState);
    }

    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password);
    }

    static final char[] getCharArray(String string) {
        char[] cArray = null;
        if (string == null) {
            cArray = new char[]{};
        } else {
            cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
        }
        return cArray;
    }

    static String bytes2String(byte[] byArray, int n2, int n3, DBConversion dBConversion) throws SQLException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return dBConversion.CharBytesToString(byArray2, n3);
    }

    void disableNio() {
        this.useNio = false;
    }

    private static synchronized void doSetSessionTimeZone(String string) throws SQLException {
        T2CConnection.t2cSetSessionTimeZone(string);
    }

    static native int getLibraryVersionNumber();

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, short var15, int var16, short[] var17, byte[] var18, byte[] var19, long[] var20);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, byte[] var15, int var16, int var17, short[] var18, byte[] var19, byte[] var20, long[] var21);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native byte t2cGetAsmVolProperty(long var1);

    private native byte t2cGetInstanceType(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1, int var3);

    private native int t2cRollback(long var1);

    private native int t2cPingDatabase(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, int var13, int var14, int var15, String[] var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, byte[] var23, int var24, byte[] var25, int var26, short[] var27, byte[] var28, byte[] var29, long[] var30);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] t2cGetConnectionId(long var1);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9, long[] var10);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, int var12, byte[][] var13);

    native int t2cCloseProxySession(long var1);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    native int t2cClearAllApplicationContext(long var1, String var3);

    native int t2cStartupDatabase(long var1, int var3);

    native int t2cShutdownDatabase(long var1, int var3);

    static native void t2cSetSessionTimeZone(String var0);

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

