/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded = false;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa11";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    public OracleXADataSource() throws SQLException {
        this.isOracleDataSource = true;
    }

    public XAConnection getXAConnection() throws SQLException {
        Properties properties = new Properties(this.connectionProperties);
        if (this.user != null && this.password != null) {
            properties.setProperty("user", this.user);
            properties.setProperty("password", this.password);
        }
        return this.getXAConnection(properties);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties(this.connectionProperties);
        if (string == null || string2 == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getXAConnection(properties);
    }

    public XAConnection getXAConnection(Properties properties) throws SQLException {
        if (this.connCachingEnabled) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 163);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (XAConnection)this.getPooledConnection(properties);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getPooledConnection(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        try {
            String string = this.getURL();
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n2 = 0;
            if ((string2 == null || string2.equals("") || string3 == null || string3.equals("")) && string != null && !string.matches("jdbc:oracle:.*/.*@.*")) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.useNativeXA && (string.startsWith("jdbc:oracle:oci8") || string.startsWith("jdbc:oracle:oci"))) {
                Class<OracleXADataSource> clazz;
                long[] lArray = new long[]{0L, 0L};
                String string7 = null;
                String string8 = null;
                OracleXADataSource oracleXADataSource = this;
                // MONITORENTER : oracleXADataSource
                string7 = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(string);
                if (string7 != null && string7.length() == 0 || string7.startsWith("(DESCRIPTION")) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 207);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!libraryLoaded) {
                    clazz = OracleXADataSource.class;
                    // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                    if (!libraryLoaded) {
                        try {
                            System.loadLibrary(dllName);
                            libraryLoaded = true;
                        }
                        catch (Error error) {
                            libraryLoaded = false;
                            throw error;
                        }
                    }
                    // MONITOREXIT : clazz
                }
                if (this.connectionProperties != null) {
                    string8 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                }
                // MONITOREXIT : oracleXADataSource
                if (string8 != null && string8.equalsIgnoreCase("true")) {
                    short s2 = T2CConnection.getDriverCharSetIdFromNLS_LANG(null);
                    this.driverCharSetIdString = Integer.toString(s2);
                } else if (!string7.equals(this.oldTnsEntry)) {
                    short s3 = T2CConnection.getClientCharSetId();
                    this.driverCharSetIdString = Integer.toString(s3);
                    this.oldTnsEntry = string7;
                }
                OracleXADataSource oracleXADataSource2 = this;
                // MONITORENTER : oracleXADataSource2
                string4 = this.databaseName + dbSuffix + rmidSeed;
                this.rmid = n2 = rmidSeed;
                clazz = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : clazz
                int n3 = 0;
                Object object = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                this.xaOpenString = string6 = this.generateXAOpenString(string4, string7, string2, string3, 60, 2000, true, true, ".", n3, false, object != null && ((String)object).equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                string5 = this.generateXACloseString(string4, false);
                // MONITOREXIT : oracleXADataSource2
                int n4 = this.t2cDoXaOpen(string6, n2, 0, 0);
                if (n4 != 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * n4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                n4 = this.t2cConvertOciHandles(string4, lArray);
                if (n4 != 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * n4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                properties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                if (this.loginTimeout != 0) {
                    properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                }
                Connection connection = this.driver.connect(this.getURL(), properties);
                ((OracleConnection)connection).setStatementCacheSize(this.maxStatements);
                ((OracleConnection)connection).setExplicitCachingEnabled(this.explicitCachingEnabled);
                ((OracleConnection)connection).setImplicitCachingEnabled(this.implicitCachingEnabled);
                if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                    ((OracleConnection)connection).setImplicitCachingEnabled(true);
                    ((OracleConnection)connection).setExplicitCachingEnabled(true);
                }
                object = new OracleXAHeteroConnection(connection);
                if (string2 != null && string3 != null) {
                    ((OraclePooledConnection)object).setUserName(string2, string3);
                }
                ((OracleXAHeteroConnection)object).setRmid(n2);
                ((OracleXAHeteroConnection)object).setXaCloseString(string5);
                ((OraclePooledConnection)object).registerCloseCallback(new OracleXAHeteroCloseCallback(), object);
                return object;
            }
            if (this.thinUseNativeXA && string.startsWith("jdbc:oracle:thin")) {
                Properties properties2 = new Properties();
                Serializable serializable = this;
                // MONITORENTER : serializable
                Class<OracleXADataSource> clazz = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : clazz
                if (this.connectionProperties == null) {
                    this.connectionProperties = new Properties();
                }
                this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                if (string2 != null) {
                    properties2.setProperty("user", string2);
                }
                if (string3 != null) {
                    properties2.setProperty("password", string3);
                }
                properties2.setProperty("stmt_cache_size", "" + this.maxStatements);
                properties2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                properties2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                properties2.setProperty("LoginTimeout", "" + this.loginTimeout);
                // MONITOREXIT : serializable
                serializable = new T4CXAConnection(super.getPhysicalConnection(properties2));
                if (string2 != null && string3 != null) {
                    ((OraclePooledConnection)serializable).setUserName(string2, string3);
                }
                clazz = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                ((OracleXAConnection)serializable).isXAResourceTransLoose = clazz != null && (((String)((Object)clazz)).equals("true") || ((String)((Object)clazz)).equalsIgnoreCase("true"));
                return serializable;
            }
            Properties properties3 = new Properties();
            Serializable serializable = this;
            // MONITORENTER : serializable
            if (string2 != null) {
                properties3.setProperty("user", string2);
            }
            if (string3 != null) {
                properties3.setProperty("password", string3);
            }
            properties3.setProperty("stmt_cache_size", "" + this.maxStatements);
            properties3.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
            properties3.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
            properties3.setProperty("LoginTimeout", "" + this.loginTimeout);
            // MONITOREXIT : serializable
            serializable = new OracleXAConnection(super.getPhysicalConnection(properties3));
            if (string2 != null && string3 != null) {
                ((OraclePooledConnection)serializable).setUserName(string2, string3);
            }
            String string9 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            ((OracleXAConnection)serializable).isXAResourceTransLoose = string9 != null && (string9.equals("true") || string9.equalsIgnoreCase("true"));
            return serializable;
        }
        catch (XAException xAException) {
            return null;
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.xaOpenString;
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        return "ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n3 + "+SESWT=" + n2 + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n4 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7;
    }

    private String generateXACloseString(String string, boolean bl) {
        return "ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f");
    }

    private String getTNSEntryFromUrl(String string) {
        int n2 = string.indexOf(64);
        return string.substring(n2 + 1);
    }
}

