/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.DatumWithConnection;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends DatumWithConnection
implements Ref,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String typename;
    transient StructDescriptor descriptor;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    public String getBaseTypeName() throws SQLException {
        if (this.typename == null) {
            if (this.descriptor != null) {
                this.typename = this.descriptor.getName();
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.typename;
    }

    public REF(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.typename = string;
        this.descriptor = null;
        this.setPhysicalConnectionOf(connection);
    }

    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
    }

    public Object getValue(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
        return object;
    }

    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            STRUCT sTRUCT;
            block7: {
                sTRUCT = null;
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(:1) from dual");
                oraclePreparedStatement.setRowPrefetch(1);
                oraclePreparedStatement.setREF(1, this);
                OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                try {
                    if (oracleResultSet.next()) {
                        sTRUCT = oracleResultSet.getSTRUCT(1);
                        break block7;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                finally {
                    oracleResultSet.close();
                    oracleResultSet = null;
                    oraclePreparedStatement.close();
                    oraclePreparedStatement = null;
                }
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            STRUCT sTRUCT = STRUCT.toSTRUCT(object, this.getInternalConnection());
            if (sTRUCT.getInternalConnection() != this.getInternalConnection()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible connection object");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible type");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byte[] byArray = sTRUCT.toBytes();
            byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.getInternalConnection().prepareCall("begin :1 := dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setBytes(2, this.shareBytes());
                callableStatement.setInt(3, 0);
                callableStatement.setBytes(4, byArray2);
                callableStatement.setBytes(5, byArray);
                callableStatement.execute();
                int n2 = 0;
                n2 = callableStatement.getInt(1);
                if (n2 != 0) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "ORA-" + n2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
    }

    public StructDescriptor getDescriptor() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = StructDescriptor.createDescriptor(this.typename, (Connection)this.getInternalConnection());
        }
        return this.descriptor;
    }

    public String getSQLTypeName() throws SQLException {
        String string = this.getBaseTypeName();
        return string;
    }

    public Object getObject(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
        return object;
    }

    public Object getObject() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
            preparedStatement.setRef(1, this);
            preparedStatement.setObject(2, object);
            preparedStatement.execute();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new REF[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        REF rEF = null;
        try {
            rEF = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException(sQLException.getMessage());
        }
        return rEF;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        try {
            bl = object instanceof REF && super.equals(object) && this.getBaseTypeName().equals(((REF)object).getSQLTypeName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public int hashCode() {
        int n2;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n2 = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        n2 *= 256;
                        n2 += byArray[8 + i2] & 0xFF;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                for (int i3 = 0; i3 < 4 && i3 < byArray.length; ++i3) {
                    n2 *= 256;
                    n2 += byArray[6 + i3] & 0xFF;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            for (int i4 = 0; i4 < 4; ++i4) {
                n2 *= 256;
                n2 += byArray[8 + i4] & 0xFF;
            }
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.shareBytes());
        try {
            objectOutputStream.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.typename = objectInputStream.readUTF();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

