/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPLTZ
extends Datum {
    private static int SIZE_TIMESTAMPLTZ = 11;
    private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
    private static int SIZE_DATE = 7;
    private static int CENTURY_DEFAULT = 119;
    private static int DECADE_DEFAULT = 100;
    private static int MONTH_DEFAULT = 1;
    private static int DAY_DEFAULT = 1;
    private static int DECADE_INIT = 170;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int MINYEAR = -4712;
    private static int MAXYEAR = 9999;
    private static boolean cached = false;
    private static Calendar dbtz;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_26_18:10:24_PDT_2010";
    public static final boolean TRACE = false;

    public TIMESTAMPLTZ() {
        super(TIMESTAMPLTZ.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMPLTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, dATE, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, string, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, time));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, date));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, dATE));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), string));
    }

    public TIMESTAMPLTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), time));
    }

    public TIMESTAMPLTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), date));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), dATE));
    }

    public TIMESTAMPLTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), Timestamp.valueOf(string)));
    }

    public static Date toDate(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, Calendar.getInstance(), byArray, calendar);
        long l2 = calendar2.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, Calendar.getInstance(), byArray, calendar);
        return new Time(calendar2.get(11), calendar2.get(12), calendar2.get(13));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, Calendar.getInstance(), byArray, calendar);
    }

    public static DATE toDATE(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        return new DATE(TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null));
    }

    public Timestamp timestampValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes(), calendar);
    }

    public static String toString(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, null, byArray, calendar);
        int n2 = calendar2.get(1);
        int n3 = calendar2.get(2) + 1;
        int n4 = calendar2.get(5);
        int n5 = calendar2.get(11);
        int n6 = calendar2.get(12);
        int n7 = calendar2.get(13);
        int n8 = -1;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n8 = TIMESTAMP.getNanos(byArray, 7);
        }
        return TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, n8, calendar2.getTimeZone().getID());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        calendar2.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar2.set(2, MONTH_DEFAULT - 1);
        calendar2.set(5, DAY_DEFAULT);
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        int n2 = timestamp.getNanos();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, n2);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        if (dATE == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(DATE.toDate(dATE.toBytes()));
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, Timestamp.valueOf(string), calendar);
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, null, byArray, null);
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        long l2 = calendar.getTime().getTime();
        return new DATE(new Timestamp(l2));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null));
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMPTZ(connection, TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null), TIMESTAMPLTZ.getSessCalendar(connection));
    }

    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, byArray, null);
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Time time) throws SQLException {
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        calendar.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar.set(2, MONTH_DEFAULT - 1);
        calendar.set(5, DAY_DEFAULT);
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar2 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar, calendar2, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Date date) throws SQLException {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar2 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar, calendar2, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        int n2 = timestamp.getNanos();
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar2 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar, calendar2, n2);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        if (dATE == null) {
            return null;
        }
        calendar.setTime(DATE.toDate(dATE.toBytes()));
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar2 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar, calendar2, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, String string) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, calendar, Timestamp.valueOf(string));
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes());
    }

    public String stringValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes());
    }

    public Time timeValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes(), calendar);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    private static byte[] initTimestampltz() {
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ];
        byArray[0] = (byte)CENTURY_DEFAULT;
        byArray[1] = (byte)DECADE_INIT;
        byArray[2] = (byte)MONTH_DEFAULT;
        byArray[3] = (byte)DAY_DEFAULT;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    private static byte[] toBytes(Connection connection, Calendar calendar, Calendar calendar2, int n2) throws SQLException {
        byte[] byArray = n2 == 0 ? new byte[SIZE_TIMESTAMPLTZ_NOFRAC] : new byte[SIZE_TIMESTAMPLTZ];
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        int n3 = calendar2.get(1);
        if (n3 < MINYEAR || n3 > MAXYEAR) {
            SQLException sQLException = DatabaseError.createSqlException(null, 268);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byArray[0] = (byte)(calendar2.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar2.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        if (n2 != 0) {
            byArray[7] = (byte)(n2 >> 24);
            byArray[8] = (byte)(n2 >> 16 & 0xFF);
            byArray[9] = (byte)(n2 >> 8 & 0xFF);
            byArray[10] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private static Timestamp toTimestamp(Connection connection, Calendar calendar, byte[] byArray, Calendar calendar2) throws SQLException {
        Calendar calendar3 = TIMESTAMPLTZ.toCalendar(connection, calendar, byArray, calendar2);
        long l2 = calendar3.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n2 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n2 = TIMESTAMP.getNanos(byArray, 7);
        }
        timestamp.setNanos(n2);
        return timestamp;
    }

    private static final Calendar toCalendar(Connection connection, Calendar calendar, byte[] byArray, Calendar calendar2) throws SQLException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = n3 == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        if (calendar2 == null) {
            TIMESTAMPLTZ.initDbTimeZone(connection);
            calendar2 = (Calendar)dbtz.clone();
        }
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        calendar2.set(14, 0);
        if (calendar == null) {
            calendar = TIMESTAMPLTZ.getSessCalendar(connection);
        }
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar);
        return calendar;
    }

    static void TimeZoneAdjust(Connection connection, Calendar calendar, Calendar calendar2) throws SQLException {
        int n2;
        int n3;
        int n4;
        TimeZone timeZone = calendar.getTimeZone();
        String string = new String(calendar.getTimeZone().getID());
        String string2 = new String(calendar2.getTimeZone().getID());
        if (!(string2.equals(string) || string2.equals("Custom") && string.equals("Custom"))) {
            int n5;
            OffsetDST offsetDST = new OffsetDST();
            n4 = TIMESTAMPLTZ.getZoneOffset(connection, calendar, offsetDST);
            n3 = offsetDST.getOFFSET();
            boolean bl = timeZone.inDaylightTime(calendar.getTime());
            calendar.add(11, -(n3 / HOUR_MILLISECOND));
            calendar.add(12, -(n3 % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            boolean bl2 = timeZone.inDaylightTime(calendar.getTime());
            if (bl && !bl2) {
                calendar.add(14, 3600000);
            } else if (!bl && bl2) {
                calendar.add(14, -3600000);
            }
            if (string2.equals("Custom")) {
                n5 = calendar2.getTimeZone().getRawOffset();
            } else {
                n2 = ZONEIDMAP.getID(string2);
                if (!ZONEIDMAP.isValidID(n2)) {
                    if (calendar2.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    n5 = calendar2.getTimeZone().getRawOffset();
                } else {
                    TIMEZONETAB tIMEZONETAB = TIMESTAMPLTZ.getTIMEZONETAB(connection);
                    if (tIMEZONETAB.checkID(n2)) {
                        tIMEZONETAB.updateTable(connection, n2);
                    }
                    n5 = tIMEZONETAB.getOffset(calendar, n2);
                }
            }
            bl = timeZone.inDaylightTime(calendar.getTime());
            calendar.add(11, n5 / HOUR_MILLISECOND);
            calendar.add(12, n5 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            bl2 = timeZone.inDaylightTime(calendar.getTime());
            if (bl && !bl2) {
                calendar.add(14, 3600000);
            } else if (!bl && bl2) {
                calendar.add(14, -3600000);
            }
        }
        if (string2.equals("Custom") && string.equals("Custom")) {
            int n6 = calendar.getTimeZone().getRawOffset();
            n4 = calendar2.getTimeZone().getRawOffset();
            n3 = 0;
            if (n6 != n4) {
                n3 = n6 - n4;
                int n7 = n3 = n3 > 0 ? n3 : -n3;
            }
            if (n6 > n4) {
                n3 = -n3;
            }
            calendar.add(11, n3 / HOUR_MILLISECOND);
            calendar.add(12, n3 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        }
        int n8 = calendar.get(1);
        n4 = calendar.get(2);
        n3 = calendar.get(5);
        n2 = calendar.get(11);
        int n9 = calendar.get(12);
        int n10 = calendar.get(13);
        int n11 = calendar.get(14);
        calendar2.set(1, n8);
        calendar2.set(2, n4);
        calendar2.set(5, n3);
        calendar2.set(11, n2);
        calendar2.set(12, n9);
        calendar2.set(13, n10);
        calendar2.set(14, n11);
    }

    private static int getJavaYear(int n2, int n3) {
        return (n2 - 100) * 100 + (n3 - 100);
    }

    private static byte getZoneOffset(Connection connection, Calendar calendar, OffsetDST offsetDST) throws SQLException {
        byte by = 0;
        if (calendar.getTimeZone().getID() == "Custom") {
            offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string);
            if (!ZONEIDMAP.isValidID(n2)) {
                if (calendar.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported");
                }
                offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
            } else {
                TIMEZONETAB tIMEZONETAB = TIMESTAMPLTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n2)) {
                    tIMEZONETAB.updateTable(connection, n2);
                }
                by = tIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            }
        }
        return by;
    }

    private static Calendar getDbTzCalendar(String string) {
        char c2 = string.charAt(0);
        String string2 = c2 == '+' || c2 == '-' ? "GMT" + string : string;
        TimeZone timeZone = TimeZone.getTimeZone(string2);
        return new GregorianCalendar(timeZone);
    }

    static Calendar getSessCalendar(Connection connection) {
        Calendar calendar;
        String string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private static synchronized void initDbTimeZone(Connection connection) throws SQLException {
        if (!cached) {
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            String string = oracleConnection.getDatabaseTimeZone();
            dbtz = TIMESTAMPLTZ.getDbTzCalendar(string);
            cached = true;
        }
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return oracleConnection.getTIMEZONETAB();
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

